/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.replacements;

import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicGenerator;
import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicNode;
import com.oracle.svm.core.graal.llvm.replacements.LLVMUnaryIntrinsicNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_1, nameTemplate="LLVMIntrinsic#{p#op}")
public class LLVMCeilNode
extends LLVMUnaryIntrinsicNode {
    public static final NodeClass<LLVMCeilNode> TYPE = NodeClass.create(LLVMCeilNode.class);

    public LLVMCeilNode(JavaKind kind, ValueNode arg) {
        super(TYPE, LLVMIntrinsicNode.LLVMIntrinsicOperation.CEIL, kind, arg);
    }

    @Override
    protected Value emitIntrinsic(LLVMIntrinsicGenerator gen, Value arg) {
        return gen.emitMathCeil(arg);
    }

    public static ConstantNode fold(JavaConstant constant) {
        return ConstantNode.forDouble((double)Math.ceil(constant.asDouble()));
    }
}

