/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.replacements;

import com.oracle.svm.core.graal.llvm.replacements.LLVMBinaryIntrinsicNode;
import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicGenerator;
import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1, nameTemplate="LLVMIntrinsic#{p#op}")
public class LLVMMaxNode
extends LLVMBinaryIntrinsicNode {
    public static final NodeClass<LLVMMaxNode> TYPE = NodeClass.create(LLVMMaxNode.class);

    public LLVMMaxNode(JavaKind kind, ValueNode arg1, ValueNode arg2) {
        super(TYPE, LLVMIntrinsicNode.LLVMIntrinsicOperation.MAX, kind, arg1, arg2);
    }

    @Override
    protected Value emitIntrinsic(LLVMIntrinsicGenerator gen, Value arg1, Value arg2) {
        return gen.emitMathMax(arg1, arg2);
    }

    public static ConstantNode fold(JavaConstant constant1, JavaConstant constant2) {
        assert (constant1.getJavaKind() == constant2.getJavaKind());
        if (constant1.getJavaKind() == JavaKind.Float) {
            return ConstantNode.forFloat((float)Math.max(constant1.asFloat(), constant2.asFloat()));
        }
        return ConstantNode.forDouble((double)Math.max(constant1.asDouble(), constant2.asDouble()));
    }
}

