/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.runtime;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.llvm.runtime.GCCExceptionTable;
import com.oracle.svm.core.graal.llvm.util.LLVMDirectives;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import java.lang.reflect.Executable;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@CContext(value=LLVMDirectives.class)
public class LLVMExceptionUnwind {
    @CEntryPoint
    @CEntryPointOptions(include=IncludeForLLVMOnly.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    public static int personality(int version, int action, IsolateThread thread, _Unwind_Exception unwindException, _Unwind_Context context) {
        Pointer ip = LLVMExceptionUnwind.getIP(context);
        Pointer functionStart = LLVMExceptionUnwind.getRegionStart(context);
        int pcOffset = NumUtil.safeToInt((long)(ip.rawValue() - functionStart.rawValue()));
        Pointer lsda = LLVMExceptionUnwind.getLanguageSpecificData(context);
        Long handlerOffset = GCCExceptionTable.getHandlerOffset(lsda, pcOffset);
        if (handlerOffset == null || handlerOffset == 0L) {
            return LLVMExceptionUnwind._URC_CONTINUE_UNWIND();
        }
        if ((action & LLVMExceptionUnwind._UA_SEARCH_PHASE()) != 0) {
            return LLVMExceptionUnwind._URC_HANDLER_FOUND();
        }
        if ((action & LLVMExceptionUnwind._UA_CLEANUP_PHASE()) != 0) {
            LLVMExceptionUnwind.setIP(context, functionStart.add(handlerOffset.intValue()));
            ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
            StackOverflowCheck.singleton().protectYellowZone();
            return LLVMExceptionUnwind._URC_INSTALL_CONTEXT();
        }
        return LLVMExceptionUnwind._URC_FATAL_PHASE1_ERROR();
    }

    @Uninterruptible(reason="Called before Java state is restored")
    public static Throwable retrieveException() {
        Throwable exception = (Throwable)ExceptionUnwind.currentException.get();
        ExceptionUnwind.currentException.set(null);
        return exception;
    }

    public static ResolvedJavaMethod getPersonalityStub(MetaAccessProvider metaAccess) {
        try {
            return ((UniverseMetaAccess)metaAccess).getUniverse().lookup((JavaMethod)CEntryPointCallStubSupport.singleton().getStubForMethod((Executable)LLVMExceptionUnwind.class.getMethod("personality", Integer.TYPE, Integer.TYPE, IsolateThread.class, _Unwind_Exception.class, _Unwind_Context.class)));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere();
        }
    }

    public static ResolvedJavaMethod getRetrieveExceptionMethod(MetaAccessProvider metaAccess) {
        try {
            return metaAccess.lookupJavaMethod((Executable)LLVMExceptionUnwind.class.getMethod("retrieveException", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere();
        }
    }

    public static void raiseException() {
        _Unwind_Exception exceptionStructure = (_Unwind_Exception)StackValue.get(_Unwind_Exception.class);
        exceptionStructure.set_exception_class((PointerBase)CurrentIsolate.getCurrentThread());
        exceptionStructure.set_exception_cleanup(WordFactory.nullPointer());
        LLVMExceptionUnwind.raiseException(exceptionStructure);
    }

    @CConstant
    private static native int _URC_NO_REASON();

    @CConstant
    private static native int _URC_FOREIGN_EXCEPTION_CAUGHT();

    @CConstant
    private static native int _URC_FATAL_PHASE2_ERROR();

    @CConstant
    private static native int _URC_FATAL_PHASE1_ERROR();

    @CConstant
    private static native int _URC_NORMAL_STOP();

    @CConstant
    private static native int _URC_END_OF_STACK();

    @CConstant
    private static native int _URC_HANDLER_FOUND();

    @CConstant
    private static native int _URC_INSTALL_CONTEXT();

    @CConstant
    private static native int _URC_CONTINUE_UNWIND();

    @CConstant
    private static native int _UA_SEARCH_PHASE();

    @CConstant
    private static native int _UA_CLEANUP_PHASE();

    @CConstant
    private static native int _UA_HANDLER_FRAME();

    @CConstant
    private static native int _UA_FORCE_UNWIND();

    @CConstant
    private static native int _UA_END_OF_STACK();

    @CFunction(value="_Unwind_RaiseException")
    public static native int raiseException(_Unwind_Exception var0);

    @CFunction(value="_Unwind_GetIP")
    public static native Pointer getIP(_Unwind_Context var0);

    @CFunction(value="_Unwind_SetIP")
    public static native Pointer setIP(_Unwind_Context var0, Pointer var1);

    @CFunction(value="_Unwind_SetGR")
    public static native Pointer setGR(_Unwind_Context var0, int var1, long var2);

    @CFunction(value="_Unwind_GetRegionStart")
    public static native Pointer getRegionStart(_Unwind_Context var0);

    @CFunction(value="_Unwind_GetLanguageSpecificData")
    public static native Pointer getLanguageSpecificData(_Unwind_Context var0);

    @CFunction(value="__builtin_eh_return_data_regno")
    public static native int builtinEHReturnDataRegno(int var0);

    @CStruct(addStructKeyword=true, isIncomplete=true)
    private static interface _Unwind_Context
    extends PointerBase {
    }

    @CStruct(addStructKeyword=true)
    private static interface _Unwind_Exception
    extends PointerBase {
        @CField
        public PointerBase exception_class();

        @CField
        public void set_exception_class(PointerBase var1);

        @CField
        public PointerBase exception_cleanup();

        @CField
        public void set_exception_cleanup(PointerBase var1);
    }

    private static class IncludeForLLVMOnly
    implements BooleanSupplier {
        private IncludeForLLVMOnly() {
        }

        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.useLLVMBackend();
        }
    }
}

