/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

final class ShadowStack {
    private final ConcurrentHashMap<Thread, ThreadLocalStack> stacks = new ConcurrentHashMap();
    private final int stackLimit;
    private final SourceSectionFilter sourceSectionFilter;
    private final Instrumenter initInstrumenter;
    private final TruffleLogger logger;

    ShadowStack(int stackLimit, SourceSectionFilter sourceSectionFilter, Instrumenter instrumenter, TruffleLogger logger) {
        this.stackLimit = stackLimit;
        this.sourceSectionFilter = sourceSectionFilter;
        this.initInstrumenter = instrumenter;
        this.logger = logger;
    }

    ThreadLocalStack getStack(Thread thread) {
        return this.stacks.get(thread);
    }

    Collection<ThreadLocalStack> getStacks() {
        return this.stacks.values();
    }

    EventBinding<?> install(final Instrumenter instrumenter, SourceSectionFilter filter, final boolean compiledOnly) {
        return instrumenter.attachExecutionEventFactory(filter, new ExecutionEventNodeFactory(){

            public ExecutionEventNode create(EventContext context) {
                Node instrumentedNode = context.getInstrumentedNode();
                if (instrumentedNode.getSourceSection() == null) {
                    ShadowStack.this.logger.warning("Instrumented node " + instrumentedNode + " has null SourceSection.");
                    return null;
                }
                return new StackPushPopNode(ShadowStack.this, instrumenter, context, compiledOnly);
            }
        });
    }

    ArrayList<StackTraceEntry> getInitialStack(Node instrumentedNode) {
        ArrayList<StackTraceEntry> sourceLocations = new ArrayList<StackTraceEntry>();
        ShadowStack.reconstructStack(sourceLocations, instrumentedNode, this.sourceSectionFilter, this.initInstrumenter);
        Truffle.getRuntime().iterateFrames(frame -> {
            Node node = frame.getCallNode();
            if (node != null) {
                ShadowStack.reconstructStack(sourceLocations, node, this.sourceSectionFilter, this.initInstrumenter);
            }
            return null;
        });
        Collections.reverse(sourceLocations);
        return sourceLocations;
    }

    private static void reconstructStack(ArrayList<StackTraceEntry> sourceLocations, Node node, SourceSectionFilter sourceSectionFilter, Instrumenter instrumenter) {
        if (node == null || sourceSectionFilter == null) {
            return;
        }
        for (Node current = node.getParent(); current != null; current = current.getParent()) {
            if (!sourceSectionFilter.includes(current) || current.getSourceSection() == null) continue;
            sourceLocations.add(new StackTraceEntry(instrumenter, current, 1));
        }
    }

    final class ThreadLocalStack {
        private static final int CORRECTION_WINDOW = 5;
        private final Thread thread;
        private final StackTraceEntry[] stack;
        private boolean stackOverflowed = false;
        @CompilerDirectives.CompilationFinal
        private Assumption noStackOverflowedAssumption = Truffle.getRuntime().createAssumption();
        private int stackIndex;
        @CompilerDirectives.CompilationFinal
        private int initialStackLength;
        @CompilerDirectives.CompilationFinal
        private Assumption initialStackLengthStable;

        ThreadLocalStack(Thread thread, int stackLimit, Node instrumentedNode) {
            this.thread = thread;
            ArrayList<StackTraceEntry> init = ShadowStack.this.getInitialStack(instrumentedNode);
            this.initialStackLength = init.size();
            this.initialStackLengthStable = this.initialStackLength > 0 ? Truffle.getRuntime().createAssumption("initial stack length stable") : null;
            this.stack = init.toArray(new StackTraceEntry[stackLimit]);
            this.stackIndex = init.size() - 1;
            this.noStackOverflowedAssumption.isValid();
        }

        void push(StackTraceEntry element) {
            if (this.noStackOverflowedAssumption.isValid()) {
                int index = this.stackIndex + 1;
                if (index < this.stack.length) {
                    assert (index >= 0);
                    this.stack[index] = element;
                } else {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.noStackOverflowedAssumption.invalidate();
                    this.stackOverflowed = true;
                }
                this.stackIndex = index;
            }
        }

        void pop(StackTraceEntry location) {
            if (this.noStackOverflowedAssumption.isValid()) {
                int index = this.stackIndex;
                if (index >= 0 && index < this.stack.length) {
                    if (this.initialStackLength > 0 && index <= this.initialStackLength && this.initialStackLengthStable.isValid()) {
                        int i;
                        CompilerDirectives.transferToInterpreter();
                        ArrayList<StackTraceEntry> reconstructedStack = ShadowStack.this.getInitialStack(location.getInstrumentedNode());
                        for (i = 0; i < reconstructedStack.size(); ++i) {
                            this.stack[i] = (StackTraceEntry)reconstructedStack.get(i);
                        }
                        for (i = reconstructedStack.size(); i < this.initialStackLength; ++i) {
                            this.stack[i] = null;
                        }
                        this.stackIndex = reconstructedStack.size() - 1;
                        if (reconstructedStack.size() != this.initialStackLength) {
                            this.initialStackLengthStable.invalidate();
                            this.initialStackLength = reconstructedStack.size();
                            this.initialStackLengthStable = this.initialStackLength > 0 ? Truffle.getRuntime().createAssumption("initial stack length stable") : null;
                        }
                    } else {
                        this.stack[index] = null;
                        this.stackIndex = index - 1;
                    }
                } else {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.noStackOverflowedAssumption.invalidate();
                    this.stackOverflowed = true;
                    this.stackIndex = index - 1;
                }
            }
        }

        StackTraceEntry top() {
            return this.stack[this.stackIndex];
        }

        StackTraceEntry[] getStack() {
            StackTraceEntry[] localStack = this.stack;
            int localStackIndex = this.stackIndex;
            if (localStackIndex == -1) {
                return null;
            }
            int length = localStackIndex + 1;
            if (length > localStack.length) {
                length = localStack.length;
            }
            localStack = Arrays.copyOf(localStack, Math.min(length + 5, localStack.length));
            for (int i = 0; i < localStack.length; ++i) {
                if (localStack[i] != null) continue;
                length = i;
                break;
            }
            if (localStack.length != length) {
                localStack = Arrays.copyOf(localStack, length);
            }
            return localStack;
        }

        Thread getThread() {
            return this.thread;
        }

        int getStackIndex() {
            return this.stackIndex;
        }

        boolean hasStackOverflowed() {
            return this.stackOverflowed;
        }
    }

    private static class StackPushPopNode
    extends ExecutionEventNode {
        private final ShadowStack profilerStack;
        private final StackTraceEntry compilationRootLocation;
        private final StackTraceEntry compiledLocation;
        private final StackTraceEntry interpretedLocation;
        private final Thread cachedThread;
        private final ThreadLocalStack cachedStack;
        @CompilerDirectives.CompilationFinal
        private boolean seenOtherThreads;
        @CompilerDirectives.CompilationFinal
        final boolean isAttachedToRootTag;
        @CompilerDirectives.CompilationFinal
        final boolean ignoreInlinedRoots;

        StackPushPopNode(ShadowStack profilerStack, Instrumenter instrumenter, EventContext context, boolean ignoreInlinedRoots) {
            this.profilerStack = profilerStack;
            this.cachedThread = Thread.currentThread();
            this.interpretedLocation = new StackTraceEntry(instrumenter, context, 1);
            this.compiledLocation = new StackTraceEntry(this.interpretedLocation, 2);
            this.compilationRootLocation = new StackTraceEntry(this.interpretedLocation, 3);
            this.isAttachedToRootTag = context.hasTag(StandardTags.RootTag.class);
            this.ignoreInlinedRoots = ignoreInlinedRoots;
            this.cachedStack = this.getStack();
        }

        protected void onEnter(VirtualFrame frame) {
            if (CompilerDirectives.inCompiledCode() && this.ignoreInlinedRoots && this.isAttachedToRootTag && !CompilerDirectives.inCompilationRoot()) {
                return;
            }
            this.doOnEnter();
        }

        private void doOnEnter() {
            StackTraceEntry location;
            StackTraceEntry stackTraceEntry = CompilerDirectives.inInterpreter() ? this.interpretedLocation : (location = CompilerDirectives.inCompilationRoot() ? this.compiledLocation : this.compilationRootLocation);
            if (this.seenOtherThreads) {
                this.pushSlow(location);
            } else if (this.cachedThread == Thread.currentThread()) {
                this.cachedStack.push(location);
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenOtherThreads = true;
                this.pushSlow(location);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void pushSlow(StackTraceEntry location) {
            this.getStack().push(location);
        }

        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            this.onReturnValue(frame, null);
        }

        protected void onReturnValue(VirtualFrame frame, Object result) {
            ThreadLocalStack stack;
            if (this.ignoreInlinedRoots && (CompilerDirectives.inCompiledCode() ? this.isAttachedToRootTag && !CompilerDirectives.inCompilationRoot() : !(stack = this.getStack()).hasStackOverflowed() && stack.top().getInstrumentedNode() != this.interpretedLocation.getInstrumentedNode())) {
                return;
            }
            if (this.seenOtherThreads) {
                this.popSlow(this.compiledLocation);
            } else if (this.cachedThread == Thread.currentThread()) {
                this.cachedStack.pop(this.compiledLocation);
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenOtherThreads = true;
                this.popSlow(this.compiledLocation);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void popSlow(StackTraceEntry entry) {
            this.getStack().pop(entry);
        }

        @CompilerDirectives.TruffleBoundary
        private ThreadLocalStack getStack() {
            Thread currentThread = Thread.currentThread();
            ThreadLocalStack stack = (ThreadLocalStack)this.profilerStack.stacks.get(currentThread);
            if (stack == null) {
                ShadowStack shadowStack = this.profilerStack;
                Objects.requireNonNull(shadowStack);
                stack = shadowStack.new ThreadLocalStack(currentThread, this.profilerStack.stackLimit, this.compiledLocation.getInstrumentedNode());
                ThreadLocalStack prevStack = this.profilerStack.stacks.putIfAbsent(currentThread, stack);
                if (prevStack != null) {
                    stack = prevStack;
                }
            }
            return stack;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }
}

