/*
 * CONSTANTS - Contains all references to dictionary items and other constant
 * 	       values that have to be compiled in for some reason or another
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * This file is placed in the public domain.
 *
 * History:
 * 2001/07/09 - EvB - Created
 * 2001/11/29 - EvB - Added some attributes from RAD-ATR as well as the
 * 		      four 'anonymous' ones from space INTERNAL
 * 2002/03/20 - EvB - Added limit on shared send queue length
 * 2003/06/23 - EvB - Increased C_MAX_MSGSIZE
 * 2003/06/23 - EvB - Added constants needed for accept/reject/acctresp ops.
 */


/*
 * DEFINES
 */


/* Maximum packet size */

#define C_MAX_PKTSIZE		4096	/* The rfc says it is */


/* Maximum interface message size (ascii or binary) */

#define C_MAX_MSGSIZE		16384	/* Seems reasonable */


/* Maximum jobs on an interface's shared send queue and maximum number
   of interface calls that may be sent to particular a subprocess before we 
   need an answer to the first one, resp. */

#define C_MAX_SENDQLEN		256
#define C_CHAN_JOBRINGSIZE	512


/* Binary message header magic number (32 bit); REQMAGIC is used for requests,
 * normally from core to module, but can also be the other way around, and in
 * that case the core will decode the request using the dictionary space 
 * C_DS_MODGROUND instead of meta_binmsgtoav; REPMAGIC is used for responses,
 * normally from modules to core, but can also be the other way around. */

#define C_BINMSG_REQMAGIC	0xbeefdead
#define C_BINMSG_REPMAGIC	0xdeadbeef


/* Maximum shared secret length */

#define C_MAX_SECRSIZE		128	/* Seems reasonable */


/* Maximum expression stack depth */

#define C_MAX_STKDEPTH		32


/* Names of the pseudo interfaces available when compiling the configuration */

#define C_IF_SOURCE_NAME	"source"
#define C_IF_IFACE_NAME		"interface"


/* Numeric references to the dictionary items that need special handling.
   These must match the values in the dictionary! You can give them any 
   names you want in the dictionary, as long as you use the values below. 
   
   In addition to the main dictionary, these come from dict.internal and
   dict.stdauth. */

#define C_DS_GROUND		0	/* Ground space, holding whole packet */
#define C_DS_RAD_PKT		1	/* Space that holds items below */

#define C_DI_CODE		0	/* Code (in above space) */
#define C_DI_IDENTIFIER		1	/* Identifier (in above spc) */
#define C_DI_AUTHENTICATOR	3	/* Authenticator (in above spc) */
					/* We sign packet here after encoding */

#define C_DV_CODE_ACCEPT	2	/* Values for RAD-Code */
#define C_DV_CODE_REJECT	3
#define C_DV_CODE_ACCTRESP	5

#define C_DS_RAD_ATR		2	/* Space that holds attributes */

#define C_DI_MSG_AUTH		80	/* Message-Authenticator attribute.
					   We sign packet here after encoding
					   if it's present on the reply list. */

#define C_DS_INTERNAL		100	/* Space that holds internal attrs */

#define C_DI_TIMESTAMP		10	/* Timestamp of request */
#define C_DI_SECRET		11	/* Shared secret to sign response */
#define C_DI_LOG_LINE		12	/* Line logged at end of expression */
#define C_DI_SERVER_PID		13	/* Replaced by PID of server after
					   processing configuration file if
					   present on request list then */
#define C_DI_REQUEST_NR		14	/* Incremented for each request */

#define C_DI_IP_SOURCE		16	/* Source IP address of request */
#define C_DI_IP_DEST		17	/* Destination address of request */
#define C_DI_UDP_SOURCE		18	/* Source UDP port of request */
#define C_DI_UDP_DEST		19	/* Destination port of request */
#define C_DI_SOURCE		20	/* Source of request (name) */
#define C_DI_DEST		21	/* Destination of request (name) */

#define C_DI_ADDR		25	/* Config: IP address to bind on */
#define C_DI_PORT		26	/* Config: UDP port to bind on */

#define C_DI_NAME		30	/* Config: Interface name */
#define C_DI_PROG		31	/* Config: Interface subprogram */
#define C_DI_SENDATTR		32	/* Config: Specs of attrs to send */
#define C_DI_RECVATTR		33	/* Config: Specs of attrs to receive */
#define C_DI_FLAGS		34	/* Config: Interface flags */
#define C_DI_TIMEOUT		35	/* Config: Timeout for subprograms */
#define C_DI_WINDOW		36	/* Config: TX window to subprograms */
#define C_DI_JOBTICKET		37	/* Config: Attribute to put job 
					   ticket in for asynchronous ifaces */
#define C_DI_PIDATTR		38	/* Config: Attribute to put selected
					   PID in for module interface, so
					   that we can route related requests
					   to the same module instance */

/* Interface flag constants (C_DI_FLAGS) */

#define C_DV_FLAGS_RESV0	1	/* Reserved for server internal use */
#define C_DV_FLAGS_RESV1	2
#define C_DV_FLAGS_RESV2	4
#define C_DV_FLAGS_RESV3	8

/* flags that affect messages through interface. Be careful with these, as
   interface programs that do not read the dictionary or include this file 
   will expect these values to stay the same. */

#define C_DV_FLAGS_ASCII	0x00010	/* ASCII-style interface */
#define C_DV_FLAGS_ADDTAB 	0x00020	/* Insert tabs in front of each line */
#define C_DV_FLAGS_ADDSPACES	0x00040	/* Add spaces around equal signs */
#define C_DV_FLAGS_ADDTYPE	0x00080	/* Add type specifications */
#define C_DV_FLAGS_HEXVALUE	0x00100	/* Send all data as hex strings */
#define C_DV_FLAGS_DBLBACKSLASH	0x00200	/* Send extra backslash when quoting */
#define C_DV_FLAGS_NAMEDCONST	0x00400	/* Send named integer constants */
#define C_DV_FLAGS_SHORTATTR	0x00800	/* Send unqualified attribute names */
#define C_DV_FLAGS_ADDIGNORE	0x01000	/* Send attributes of type 'ignore' */

#define C_DV_FLAGS_RESV5	0x02000	/* Reserved for future flags that */
#define C_DV_FLAGS_RESV6	0x04000 /* define interface message layout */
#define C_DV_FLAGS_RESV7	0x08000
#define C_DV_FLAGS_RESV8	0x10000
#define C_DV_FLAGS_RESV9	0x20000
#define C_DV_FLAGS_RESV10	0x40000
#define C_DV_FLAGS_RESV11	0x80000

/* flags that affect the behaviour of interfaces themselves */

#define C_DV_FLAGS_BROADCAST	0x0100000	/* Broadcast to progs */
#define C_DV_FLAGS_ALL		0x0200000	/* Allow/require all to answ. */

#define C_DV_FLAGS_RESV12	0x0400000	/* Reserved for future flags */
#define C_DV_FLAGS_RESV13	0x0800000	/* for interface behaviour */
#define C_DV_FLAGS_RESV14	0x1000000
#define C_DV_FLAGS_RESV15	0x2000000

/* all bits beyond this number are for server internal use */

#define C_DV_FLAGS_USEDBITS	26


/************************************************************************
 * The following constants are not used by the server itself, but are
 * intended for use by modules that use the binary interface and don't
 * read the dictionary.
 */

/* The 'any vendor' vendor */

#define C_VND_ANY		((-LONG_MAX)-1)	  /* eq. of -128 resp. -32768 */


/* The four 'anonymous' attributes, all in space C_DS_INTERNAL */

#define C_DI_INT		1
#define C_DI_IP			2
#define C_DI_DATE		3
#define C_DI_STR		4


/* Some common RADIUS attributes. Try to avoid VSAs here. */

#define C_DS_RAD_ATR		2	/* Space that has the radius attrs */

#define C_DI_USER_NAME		1	/* Used by eg. RadLDAP */
#define C_DI_USER_PASSWORD	2	/* Used by eg. RadLDAP */

/* Attributes for modules that pass a transaction ID around. In DS_INTERNAL */

#define C_DI_TID		50	/* Used by eg. EAPTLS */

