if (OPENSLES_LIBRARIES AND OPENSLES_INCLUDE_DIRS)
  # in cache already
  set(OPENSLES_FOUND TRUE)
else (OPENSLES_LIBRARIES AND OPENSLES_INCLUDE_DIRS)
  if (OPENSLES_FOUND)
    set(OPENSLES_INCLUDE_DIRS
      ${OPENSLES_INCLUDE_DIRS}
    )   
    set(OPENSLES_LIBRARIES
      ${OPENSLES_LIBRARIES}
    )
    set(OPENSLES_FOUND TRUE)
  else (OPENSLES_FOUND)
    find_path(OPENSLES_INCLUDE_DIR
      NAMES
        SLES/OpenSLES.h
    )

    find_library(OPENSLES_LIBRARY
      NAMES
        OpenSLES
    )

    set(OPENSLES_INCLUDE_DIRS
      ${OPENSLES_INCLUDE_DIR}
    )
    
    set(OPENSLES_LIBRARIES
      ${OPENSLES_LIBRARY}
    )

    if (OPENSLES_INCLUDE_DIRS AND OPENSLES_LIBRARIES)
       set(OPENSLES_FOUND TRUE)
    endif (OPENSLES_INCLUDE_DIRS AND OPENSLES_LIBRARIES)

    if (OPENSLES_FOUND)
      if (NOT OpenSLES_FIND_QUIETLY)
        message(STATUS "Found OpenSLES: ${OPENSLES_LIBRARIES}")
      endif (NOT OpenSLES_FIND_QUIETLY)
    else (OPENSLES_FOUND)
      if (OpenSLES_FIND_REQUIRED)
        message(FATAL_ERROR "Could not find OpenSLES")
      endif (OpenSLES_FIND_REQUIRED)
    endif (OPENSLES_FOUND)
  endif (OPENSLES_FOUND)

  # show the OPENSLES_INCLUDE_DIRS and OPENSLES_LIBRARIES variables only in the advanced view
  mark_as_advanced(OPENSLES_INCLUDE_DIRS OPENSLES_LIBRARIES)

endif (OPENSLES_LIBRARIES AND OPENSLES_INCLUDE_DIRS)