# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0004 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63112);
 script_cve_id("CVE-2008-5077");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0004";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0004.

OpenSSL is a toolkit that implements Secure Sockets Layer (SSL v2/v3) and
Transport Layer Security (TLS v1) protocols as well as a full-strength,
general purpose, cryptography library.

The Google security team discovered a flaw in the way OpenSSL checked the
verification of certificates. An attacker in control of a malicious server,
or able to effect a man in the middle attack, could present a malformed
SSL/TLS signature from a certificate chain to a vulnerable client and
bypass validation. (CVE-2008-5077)

All OpenSSL users should upgrade to these updated packages, which contain
backported patches to resolve these issues. For the update to take effect,
all running OpenSSL client applications must be restarted, or the system
rebooted.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0004.html
http://www.openssl.org/news/secadv_20090107.txt
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0004";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.6b~49", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-devel", rpm:"openssl-devel~0.9.6b~49", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-perl", rpm:"openssl-perl~0.9.6b~49", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl095a", rpm:"openssl095a~0.9.5a~34", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl096", rpm:"openssl096~0.9.6~34", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.7a~33.25", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-debuginfo", rpm:"openssl-debuginfo~0.9.7a~33.25", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-devel", rpm:"openssl-devel~0.9.7a~33.25", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-perl", rpm:"openssl-perl~0.9.7a~33.25", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl096b", rpm:"openssl096b~0.9.6b~16.49", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl096b-debuginfo", rpm:"openssl096b-debuginfo~0.9.6b~16.49", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.7a~43.17.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-debuginfo", rpm:"openssl-debuginfo~0.9.7a~43.17.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-devel", rpm:"openssl-devel~0.9.7a~43.17.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-perl", rpm:"openssl-perl~0.9.7a~43.17.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl096b", rpm:"openssl096b~0.9.6b~22.46.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl096b-debuginfo", rpm:"openssl096b-debuginfo~0.9.6b~22.46.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8b~10.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-debuginfo", rpm:"openssl-debuginfo~0.9.8b~10.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-perl", rpm:"openssl-perl~0.9.8b~10.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl097a", rpm:"openssl097a~0.9.7a~9.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl097a-debuginfo", rpm:"openssl097a-debuginfo~0.9.7a~9.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-devel", rpm:"openssl-devel~0.9.8b~10.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
