# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0009 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63250);
 script_cve_id("CVE-2008-0598", "CVE-2008-3528", "CVE-2008-3831", "CVE-2008-4554", "CVE-2008-4576", "CVE-2008-4618", "CVE-2008-5029");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0009";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to the kernel announced in
advisory RHSA-2009:0009.

These updated packages address the following security issues:

* Tavis Ormandy discovered a deficiency in the Linux kernel 32-bit and
64-bit emulation. This could allow a local, unprivileged user to prepare
and run a specially-crafted binary which would use this deficiency to leak
uninitialized and potentially sensitive data. (CVE-2008-0598, Important)

* Olaf Kirch reported a flaw in the i915 kernel driver that only affects
the Intel G33 series and newer. This flaw could, potentially, lead to local
privilege escalation. (CVE-2008-3831, Important)

* Miklos Szeredi reported a missing check for files opened with O_APPEND in
sys_splice(). This could allow a local, unprivileged user to bypass the
append-only file restrictions. (CVE-2008-4554, Important)

* a deficiency was found in the Linux kernel Stream Control Transmission
Protocol (SCTP) implementation. This could lead to a possible denial of
service if one end of a SCTP connection did not support the AUTH extension.
(CVE-2008-4576, Important)

* Wei Yongjun reported a flaw in the Linux kernel SCTP implementation. In
certain code paths, sctp_sf_violation_paramlen() could be called with a
wrong parameter data type. This could lead to a possible denial of service.
(CVE-2008-4618, Important)

* when fput() was called to close a socket, the __scm_destroy() function in
the Linux kernel could make indirect recursive calls to itself. This could,
potentially, lead to a denial of service issue. (CVE-2008-5029, Important)

* the ext2 and ext3 filesystem code failed to properly handle corrupted
data structures, leading to a possible local denial of service issue when
read or write operations were performed. (CVE-2008-3528, Low)

All Red Hat Enterprise MRG users should install this update which addresses
these vulnerabilities and fixes these bugs.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0009.html
http://www.redhat.com/security/updates/classification/#important
http://www.redhat.com/docs/en-US/Red_Hat_Enterprise_MRG/

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0009";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-rt", rpm:"kernel-rt~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug", rpm:"kernel-rt-debug~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug-debuginfo", rpm:"kernel-rt-debug-debuginfo~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug-devel", rpm:"kernel-rt-debug-devel~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debuginfo", rpm:"kernel-rt-debuginfo~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debuginfo-common", rpm:"kernel-rt-debuginfo-common~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-devel", rpm:"kernel-rt-devel~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace", rpm:"kernel-rt-trace~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace-debuginfo", rpm:"kernel-rt-trace-debuginfo~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace-devel", rpm:"kernel-rt-trace-devel~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla", rpm:"kernel-rt-vanilla~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla-debuginfo", rpm:"kernel-rt-vanilla-debuginfo~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla-devel", rpm:"kernel-rt-vanilla-devel~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-doc", rpm:"kernel-rt-doc~2.6.24.7~93.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
