# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0296 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63517);
 script_cve_id("CVE-2008-1036");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0296";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0296.

The International Components for Unicode (ICU) library provides robust and
full-featured Unicode services.

A flaw was found in the way ICU processed certain, invalid, encoded data.
If an application used ICU to decode malformed, multibyte, character data,
it may have been possible to bypass certain content protection mechanisms,
or display information in a manner misleading to the user. (CVE-2008-1036)

All users of icu should upgrade to these updated packages, which contain
backported patches to resolve these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0296.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0296";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"icu", rpm:"icu~3.6~5.11.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"icu-debuginfo", rpm:"icu-debuginfo~3.6~5.11.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libicu", rpm:"libicu~3.6~5.11.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libicu-doc", rpm:"libicu-doc~3.6~5.11.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libicu-devel", rpm:"libicu-devel~3.6~5.11.2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
