# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0341 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63584);
 script_cve_id("CVE-2009-0037");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0341";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0341.

cURL is a tool for getting files from FTP, HTTP, Gopher, Telnet, and Dict
servers, using any of the supported protocols. cURL is designed to work
without user interaction or any kind of interactivity.

David Kierznowski discovered a flaw in libcurl where it would not
differentiate between different target URLs when handling automatic
redirects. This caused libcurl to follow any new URL that it understood,
including the file:// URL type. This could allow a remote server to force
a local libcurl-using application to read a local file instead of the
remote one, possibly exposing local files that were not meant to be
exposed. (CVE-2009-0037)

Note: Applications using libcurl that are expected to follow redirects to
file:// protocol must now explicitly call curl_easy_setopt(3) and set the
newly introduced CURLOPT_REDIR_PROTOCOLS option as required.

cURL users should upgrade to these updated packages, which contain
backported patches to correct these issues. All running applications using
libcurl must be restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0341.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0341";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"curl", rpm:"curl~7.8~3.rhel2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-devel", rpm:"curl-devel~7.8~3.rhel2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.10.6~9.rhel3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-debuginfo", rpm:"curl-debuginfo~7.10.6~9.rhel3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-devel", rpm:"curl-devel~7.10.6~9.rhel3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.12.1~11.1.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-debuginfo", rpm:"curl-debuginfo~7.12.1~11.1.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-devel", rpm:"curl-devel~7.12.1~11.1.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.15.5~2.1.el5_3.4", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-debuginfo", rpm:"curl-debuginfo~7.15.5~2.1.el5_3.4", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-devel", rpm:"curl-devel~7.15.5~2.1.el5_3.4", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
