###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Check for ident Service 
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
 script_id(100081);
 script_version ("1.0");

 name["english"] = "Check for ident Service";
 script_name(english:name["english"]);
 
 desc["english"] = "
  Overview:
   
   The remote host is running an ident daemon.

   The Ident Protocol is designed to work as a server daemon, on a user's
   computer, where it receives requests to a specified port, generally 113. The
   server will then send a specially designed response that identifies the
   username of the current user.

   The ident protocol is considered dangerous because it allows hackers to gain
   a list of usernames on a computer system which can later be used for attacks. 
 
  Risk factor : Low";

 script_description(english:desc["english"]);
 summary["english"] = "Check for ident Service";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 family["english"] = "Useless services";
 script_family(english:family["english"]);
 script_dependencies("find_service.nes");
 script_require_ports("Services/auth", 113);
 exit(0);
}

include("misc_func.inc");

port = get_kb_item("Services/auth");
if(!port)port = 113;
if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);
 
  data = strcat(port, ',', get_source_port(soc));
  send(socket:soc, data:string(data,"\r\n"));
  buf = recv_line(socket:soc, length:1024);

  if("ERROR" >< buf || data >< buf || "USERID" >< buf)
  {
   security_note(port);
   register_service(port:port, proto:"auth");
  }
  close(soc);

exit(0);  
