# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 002-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53768);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 002-1 (fsh)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to fsh
announced via advisory DSA 002-1.

Colin Phipps found an interesting symlink attack problem in fsh (a
tool to quickly run remote commands over rsh/ssh/lsh). When fshd
starts it creates a directory in /tmp to hold its sockets. It tries
to do that securely by checking of it can chown that directory if
it already exists to check if it is owner by the user invoking it.
However an attacker can circumvent this check by inserting a
symlink to a file that is owner by the user who runs fhsd and
replacing that with a directory just before fshd creates the
socket.

This has been fixed in version 1.0.post.1-3potato.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20002-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 002-1 (fsh)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"fsh", ver:"1.0.post.1-3potato", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
