# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 017-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53780);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 017-1 (jazip)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to jazip
announced via advisory DSA 017-1.

With older versions of jazip a user could gain root access for members
of the floppy group to the local machine.  The interface doesn't run
as root anymore and this very exploit was prevented.  The program now
also truncates DISPLAY to 256 characters if it is bigger, which closes
the buffer overflow (within xforms).

We recommend you upgrade your jazip package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20017-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 017-1 (jazip)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"jazip", ver:"0.33-1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
