# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 100-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53760);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 100-1 (gzip)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gzip
announced via advisory DSA 100-1.

GOBBLES found a buffer overflow in gzip that occurs when compressing
files with really long filenames.  Even though GOBBLES claims to have
developed an exploit to take advantage of this bug, it has been said
by others that this problem is not likely to be exploitable as other
security incidents.

Additionally, the Debian version of gzip from the stable release does
not segfault, and hence does not directly inherit this problem.
However, better be safe than sorry, so we have prepared an update for
you.

Please make sure you are running an up-to-date version from
stable/unstable/testing with at least version 1.2.4-33.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20100-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 100-1 (gzip)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gzip", ver:"1.2.4-33.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
