# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1024-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56529);
 script_cve_id("CVE-2006-1614", "CVE-2006-1615", "CVE-2006-1630");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1024-1 (clamav)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to clamav
announced via advisory DSA 1024-1.

Several remote vulnerabilities have been discovered in the ClamAV
anti-virus toolkit, which may lead to denial of service and potentially
to the execution of arbitrary code. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2006-1614

Damian Put discovered an integer overflow in the PE header parser.
This is only exploitable if the ArchiveMaxFileSize option is disabled.

CVE-2006-1615

Format string vulnerabilities in the logging code have been discovered,
which might lead to the execution of arbitrary code.

CVE-2006-1630

David Luyer discovered, that ClamAV can be tricked into an invalid
memory access in the cli_bitset_set() function, which may lead to
a denial of service.

The old stable distribution (woody) doesn't contain clamav packages.

For the stable distribution (sarge) these problems have been fixed in
version 0.84-2.sarge.8.

For the unstable distribution (sid) these problems have been fixed in
version 0.88.1-1.

We recommend that you upgrade your clamav package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201024-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1024-1 (clamav)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-base", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav1", ver:"0.84-2.sarge.8", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
