# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1029-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56535);
 script_cve_id("CVE-2006-0146", "CVE-2006-0147", "CVE-2006-0410", "CVE-2006-0806");
 script_bugtraq_id(16187,16364,16720);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1029-1 (libphp-adodb)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libphp-adodb
announced via advisory DSA 1029-1.

Several vulnerabilities have been discovered in libphp-adodb, the 'adodb'
database abstraction layer for PHP.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2006-0146

Andreas Sandblad discovered that improper user input sanitisation
results in a potential remote SQL injection vulnerability enabling
an attacker to compromise applications, access or modify data, or
exploit vulnerabilities in the underlying database implementation.
This requires the MySQL root password to be empty.  It is fixed by
limiting access to the script in question.

CVE-2006-0147

A dynamic code evaluation vulnerability allows remote attackers to
execute arbitrary PHP functions via the 'do' parameter.

CVE-2006-0410

Andy Staudacher discovered an SQL injection vulnerability due to
insufficient input sanitising that allows remote attackers to
execute arbitrary SQL commands.

CVE-2006-0806

GulfTech Security Research discovered multiple cross-site
scripting vulnerabilities due to improper user-supplied input
sanitisation.  Attackers can exploit these vulnerabilities to
cause arbitrary scripts to be executed in the browser of an
unsuspecting user's machine, or result in the theft of
cookie-based authentication credentials.

For the old stable distribution (woody) these problems have been fixed in
version 1.51-1.2.

For the stable distribution (sarge) these problems have been fixed in
version 4.52-1sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 4.72-0.1.

We recommend that you upgrade your libphp-adodb package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201029-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1029-1 (libphp-adodb)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libphp-adodb", ver:"1.51-1.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libphp-adodb", ver:"4.52-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
