# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1079-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56833);
 script_cve_id("CVE-2006-0903", "CVE-2006-1516", "CVE-2006-1517", "CVE-2006-1518");
 script_bugtraq_id(16850,17780);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1079-1 (mysql-dfsg)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mysql-dfsg
announced via advisory DSA 1079-1.

Several vulnerabilities have been discovered in MySQL, a popular SQL
database.  The Common Vulnerabilities and Exposures Project identifies
the following problems:

CVE-2006-0903

Improper handling of SQL queries containing the NULL character
allow local users to bypass logging mechanisms.

CVE-2006-1516

Usernames without a trailing null byte allow remote attackers to
read portions of memory.

CVE-2006-1517

A request with an incorrect packet length allows remote attackers
to obtain sensitive information.

CVE-2006-1518

Specially crafted request packets with invalid length values allow
the execution of arbitrary code.

The following vulnerability matrix shows which version of MySQL in
which distribution has this problem fixed:

woody            sarge            sid
mysql            3.23.49-8.15        n/a             n/a
mysql-dfsg          n/a         4.0.24-10sarge2      n/a
mysql-dfsg-4.1      n/a         4.1.11a-4sarge3      n/a
mysql-dfsg-5.0      n/a              n/a           5.0.21-3

We recommend that you upgrade your mysql packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201079-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1079-1 (mysql-dfsg)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-common", ver:"4.0.24-10sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient12", ver:"4.0.24-10sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient12-dev", ver:"4.0.24-10sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"4.0.24-10sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"4.0.24-10sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
