# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1168-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57336);
 script_cve_id("CVE-2006-2440", "CVE-2006-3743", "CVE-2006-3744");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1168-1 (imagemagick)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to imagemagick
announced via advisory DSA 1168-1.

Several remote vulnerabilities have been discovered in Imagemagick, a
collection of image manipulation tools, which may lead to the execution
of arbitrary code. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2006-2440

Eero Hkkinen discovered that the display tool allocates insufficient
memory for globbing patterns, which might lead to a buffer overflow.

CVE-2006-3743

Tavis Ormandy from the Google Security Team discovered that the Sun
bitmap decoder performs insufficient input sanitising, which might
lead to buffer overflows and the execution of arbitrary code.

CVE-2006-3744

Tavis Ormandy from the Google Security Team discovered that the XCF
image decoder performs insufficient input sanitising, which might
lead to buffer overflows and the execution of arbitrary code.

For the stable distribution (sarge) these problems have been fixed in
version 6:6.0.6.2-2.7.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your imagemagick packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201168-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1168-1 (imagemagick)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imagemagick", ver:"6.0.6.2-2.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6", ver:"6.0.6.2-2.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6-dev", ver:"6.0.6.2-2.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6", ver:"6.0.6.2-2.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6-dev", ver:"6.0.6.2-2.7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.0.6.2-2.7", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
