# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1170-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57338);
 script_cve_id("CVE-2006-3619");
 script_bugtraq_id(15669);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1170-1 (gcc-3.4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gcc-3.4
announced via advisory DSA 1170-1.

Jrgen Weigert discovered that upon unpacking JAR archives fastjar
from the GNU Compiler Collection does not check the path for included
files and allows to create or overwrite files in upper directories.

For the stable distribution (sarge) this problem has been fixed in
version 3.4.3-13sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 4.1.1-11.

We recommend that you upgrade your fastjar package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201170-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1170-1 (gcc-3.4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cpp-3.4-doc", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"g77-3.4-doc", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gcc-3.4-doc", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnat-3.4-doc", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gpc-2.1-3.4-doc", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgcj5-common", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-doc", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cpp-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fastjar", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"g++-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"g77-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gcc-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gcc-3.4-base", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gcj-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gij-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnat-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gobjc-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gpc-2.1-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libffi3", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libffi3-dev", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgcc1", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgcj5", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgcj5-awt", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgcj5-dev", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-dbg", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-dev", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-pic", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"treelang-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32gcc1", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32stdc++6", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnat-3.4", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-0", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-0-dbg", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-0-dev", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstdc++6-0-pic", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gcc-3.4-hppa64", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgcc2", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib64gcc1", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib64stdc++6", ver:"3.4.3-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
