# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1241-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57749);
 script_cve_id("CVE-2006-6142");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1241-1 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory DSA 1241-1.

Martijn Brinkers discovered cross-site scripting vulnerabilities in the
the mailto parameter of webmail.php, the session and delete_draft
parameters of compose.php and through a shortcoming in the magicHTML
filter. An attacker could abuse these to execute malicious JavaScript in
the user's webmail session.

Also, a workaround was made for Internet Explorer <= 5: IE will attempt
to guess the MIME type of attachments based on content, not the MIME
header sent. Attachments could fake to be an 'harmless' JPEG, while they
were in fact HTML that Internet Explorer would render.

For the stable distribution (sarge) these problems have been fixed in
version 2:1.4.4-10.

For the upcoming stable distribution (etch) these problems have been fixed
in version 2:1.4.9a-1.

For the unstable distribution (sid) these problems have been fixed in
version 2:1.4.9a-1.

We recommend that you upgrade your squirrelmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201241-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1241-1 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.4.4-10", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
