# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1333-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58465);
 script_cve_id("CVE-2007-3564");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1333-1 (libcurl3-gnutls)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libcurl3-gnutls
announced via advisory DSA 1333-1.

It has been discovered that the GnuTLS certificate verification methods
implemented in libcurl-gnutls, a solid, usable, and portable multi-protocol
file transfer library, did not check for expired or invalid dates.

For the stable distribution (etch), this problem has been fixed in
version 7.15.5-1etch1.

We recommend that you upgrade your libcurl3-gnutls package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201333-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1333-1 (libcurl3-gnutls)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcurl3-dev", ver:"7.15.5-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls-dev", ver:"7.15.5-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.15.5-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.15.5-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-openssl-dev", ver:"7.15.5-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.15.5-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls", ver:"7.15.5-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
