# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1461-1 (libxml2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60181);
 script_cve_id("CVE-2007-6284");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1461-1 (libxml2)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libxml2
announced via advisory DSA 1461-1.

Brad Fitzpatrick discovered that the UTF-8 decoding functions of libxml2,
the GNOME XML library, validate UTF-8 correctness insufficiently, which
may lead to denial of service by forcing libxml2 into an infinite loop.

For the unstable distribution (sid), this problem will be fixed soon.

For the stable distribution (etch), this problem has been fixed in
version 2.6.27.dfsg-2.

For the old stable distribution (sarge), this problem has been fixed in
version 2.6.16-7sarge1.

We recommend that you upgrade your libxml2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201461-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1461-1 (libxml2)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-python2.3", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-libxml2", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-libxml2", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-libxml2", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.16-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.27.dfsg-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.27.dfsg-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.27.dfsg-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.27.dfsg-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.27.dfsg-2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.27.dfsg-2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
