# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1646-2 (squid)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61771);
 script_cve_id("CVE-2008-1612", "CVE-2007-6239");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1646-2 (squid)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squid
announced via advisory DSA 1646-2.

In DSA 1646-1, an update was announced for a denial of service
vulnerability in squid, a caching proxy server.  Due to an error in
packaging and in testing, the updated packages did not correct the
weakness.  An updated release is available which corrects the error.
For reference, the original advisory text follows.

A weakness has been discovered in squid, a caching proxy server.  The
flaw was introduced upstream in response to CVE-2007-6239, and
announced by Debian in DSA-1482-1.  The flaw involves an
over-aggressive bounds check on an array resize, and could be
exploited by an authorized client to induce a denial of service
condition against squid.

For the stable distribution (etch), these problems have been fixed in
version 2.6.5-6etch4.

We recommend that you upgrade your squid packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201646-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1646-2 (squid)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid-common", ver:"2.6.5-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.6.5-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"2.6.5-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid", ver:"2.6.5-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
