# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1673-1 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61936);
 script_cve_id("CVE-2008-3137", "CVE-2008-3138", "CVE-2008-3141", "CVE-2008-3145", "CVE-2008-3933", "CVE-2008-4683", "CVE-2008-4684", "CVE-2008-4685");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1673-1 (wireshark)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to wireshark
announced via advisory DSA 1673-1.

Several remote vulnerabilities have been discovered network traffic
analyzer Wireshark. For details, please visit the referenced security
advisories.

For the stable distribution (etch), these problems have been fixed in
version 0.99.4-5.etch.3.

For the upcoming stable distribution (lenny), these problems have been
fixed in version 1.0.2-3+lenny2.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your wireshark packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201673-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1673-1 (wireshark)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-common", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-dev", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tshark", ver:"0.99.4-5.etch.3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
