# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1746-1 (ghostscript)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63678);
 script_cve_id("CVE-2009-0583", "CVE-2009-0584");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1746-1 (ghostscript)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ghostscript
announced via advisory DSA 1746-1.

Two security issues have been discovered in ghostscript, the GPL
Ghostscript PostScript/PDF interpreter. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2009-0583

Jan Lieskovsky discovered multiple integer overflows in the ICC library,
which allow the execution of arbitrary code via crafted ICC profiles in
PostScript files with embedded images.

CVE-2009-0584

Jan Lieskovsky discovered insufficient upper-bounds checks on certain
variable sizes in the ICC library, which allow the execution of
arbitrary code via crafted ICC profiles in PostScript files with
embedded images.


For the stable distribution (lenny), these problems have been fixed in
version 8.62.dfsg.1-3.2lenny1.

For the oldstable distribution (etch), these problems have been fixed
in version 8.54.dfsg.1-5etch2. Please note that the package in oldstable
is called gs-gpl.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems will be fixed soon.

We recommend that you upgrade your ghostscript/gs-gpl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201746-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1746-1 (ghostscript)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gs", ver:"8.54.dfsg.1-5etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.54.dfsg.1-5etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-common", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-doc", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-aladdin", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs8", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-x", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-dev", ver:"8.62.dfsg.1-3.2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
