# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1748-1 (libsoup)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63679);
 script_cve_id("CVE-2009-0585");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1748-1 (libsoup)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libsoup
announced via advisory DSA 1748-1.

It was discovered that libsoup, an HTTP library implementation in C,
handles large strings insecurely via its Base64 encoding functions. This
could possibly lead to the execution of arbitrary code.

For the oldstable distribution (etch), this problem has been fixed in
version 2.2.98-2+etch1.

The stable distribution (lenny) is not affected by this issue.

The testing distribution (squeeze) and the unstable distribution (sid)
are not affected by this issue.

We recommend that you upgrade your libsoup packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201748-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1748-1 (libsoup)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsoup2.2-doc", ver:"2.2.98-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsoup2.2-8", ver:"2.2.98-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsoup2.2-dev", ver:"2.2.98-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
