# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1779-1 (apt)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63932);
 script_cve_id("CVE-2009-1300", "CVE-2009-1358");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1779-1 (apt)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to apt
announced via advisory DSA 1779-1.

Two vulnerabilities have been discovered in APT, the well-known dpkg
frontend. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2009-1300

In time zones where daylight savings time occurs at midnight,
the apt cron.daily script fails, stopping new security updates
from being applied automatically.

CVE-2009-1358

A repository that has been signed with an expired or revoked
OpenPGP key would still be considered valid by APT.

For the old stable distribution (etch), these problems have been fixed in
version 0.6.46.4-0.1+etch1.

For the stable distribution (lenny), these problems have been fixed in
version 0.7.20.2+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 0.7.21.

We recommend that you upgrade your apt package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201779-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1779-1 (apt)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apt-doc", ver:"0.6.46.4-0.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapt-pkg-doc", ver:"0.6.46.4-0.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apt-utils", ver:"0.6.46.4-0.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapt-pkg-dev", ver:"0.6.46.4-0.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apt", ver:"0.6.46.4-0.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apt-doc", ver:"0.7.20.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapt-pkg-doc", ver:"0.7.20.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apt-transport-https", ver:"0.7.20.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapt-pkg-dev", ver:"0.7.20.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apt-utils", ver:"0.7.20.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apt", ver:"0.7.20.2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
