# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1802-2 (squirrelmail)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64037);
 script_cve_id("CVE-2009-1578", "CVE-2009-1579", "CVE-2009-1580", "CVE-2009-1581", "CVE-2009-1381");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1802-2 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory DSA 1802-2.

Michal Hlavinka discovered that the fix for code execution in the
map_yp_alias function, known as CVE-2009-1579 and released in DSA 1802-1,
was incomplete. This update corrects the fix for that function.

For the old stable distribution (etch), this problem has been fixed in
version 1.4.9a-5.

For the stable distribution (lenny), this problem has been fixed in
version 1.4.15-4+lenny2.

For the unstable distribution (sid), this problem has been fixed in
version 1.4.19-1

We recommend that you upgrade your squirrelmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201802-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1802-2 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.4.9a-5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.4.15-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
