# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 191-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53736);
 script_cve_id("CVE-2002-1131", "CVE-2002-1132");
 script_bugtraq_id(5949);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 191-1 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory DSA 191-1.

Several cross site scripting vulnerabilities have been found in
squirrelmail, a feature-rich webmail package written in PHP4.  The
Common Vulnerabilities and Exposures (CVE) project identified the
following vulnerabilities:

1. CVE-2002-1131: User input is not always sanitized so execution of
arbitrary code on a client computer is possible.  This can happen
after following a malicious URL or by viewing a malicious
addressbook entry.

2. CVE-2002-1132: Another problem could make it possible for an
attacker to gain sensitive information under some conditions.
When a malformed argument is appended to a link, an error page
will be generated which contains the absolute pathname of the
script.  However, this information is available through the
Contents file of the distribution anyway.

These problems have been fixed in version 1.2.6-1.1 the current stable
distribution (woody) and in version 1.2.8-1.1 for the unstable
distribution (sid).  The old stable distribution (potato) is not
affected since it doesn't contain a squirrelmail package

We recommend that you upgrade your squirrelmail package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20191-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 191-1 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.2.6-1.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
