# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 363-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53652);
 script_cve_id("CVE-2003-0468", "CVE-2003-0540");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 363-1 (postfix)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to postfix
announced via advisory DSA 363-1.

The postfix mail transport agent in Debian 3.0 contains two
vulnerabilities:

CVE-2003-0468: Postfix would allow an attacker to bounce-scan private
networks or use the daemon as a DDoS tool by forcing the daemon to
connect to an arbitrary service at an arbitrary IP address and
either receiving a bounce message or observing queue operations to
infer the status of the delivery attempt.

CVE-2003-0540: a malformed envelope address can 1) cause the queue
manager to lock up until an entry is removed from the queue and 2)
lock up the smtp listener leading to a denial of service

For the current stable distribution (woody) these problems have been
fixed in version 1.1.11-0.woody3.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you update your postfix package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20363-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 363-1 (postfix)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postfix-dev", ver:"1.1.11-0.woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-doc", ver:"1.1.11-0.woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix", ver:"1.1.11-0.woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-ldap", ver:"1.1.11-0.woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-mysql", ver:"1.1.11-0.woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-pcre", ver:"1.1.11-0.woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
