# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 672-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53501);
 script_cve_id("CVE-2005-0076");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 672-1 (xview)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xview
announced via advisory DSA 672-1.

Erik Sjlund discovered that programs linked against xview are
vulnerable to a number of buffer overflows in the XView library.  When
the overflow is triggered in a program which is installed setuid root
a malicious user could perhaps execute arbitrary code as privileged
user.

For the stable distribution (woody) these problems have been fixed in
version 3.2p1.4-16woody2.

For the unstable distribution (sid) these problems have been fixed in
version 3.2p1.4-19.

We recommend that you upgrade your xview packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20672-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 672-1 (xview)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"olvwm", ver:"4.4.3.2p1.4-16woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"olwm", ver:"3.2p1.4-16woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xview-clients", ver:"3.2p1.4-16woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xview-examples", ver:"3.2p1.4-16woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xviewg", ver:"3.2p1.4-16woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xviewg-dev", ver:"3.2p1.4-16woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
