# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 696-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53525);
 script_bugtraq_id(12767);
 script_cve_id("CVE-2005-0448");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 696-1 (perl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to perl
announced via advisory DSA 696-1.

Paul Szabo discovered another vulnerability in the File::Path::rmtree
function of perl, the popular scripting language.  When a process is
deleting a directory tree, a different user could exploit a race
condition to create setuid binaries in this directory tree, provided
that he already had write permissions in any subdirectory of that
tree.

For the stable distribution (woody) this problem has been fixed in
version 5.6.1-8.9.

For the unstable distribution (sid) this problem has been fixed in
version 5.8.4-8.

We recommend that you upgrade your perl packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20696-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 696-1 (perl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.6", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.6.1-8.9", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
