# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 715-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53543);
 script_cve_id("CVE-2004-1342", "CVE-2004-1343");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 715-1 (cvs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to cvs
announced via advisory DSA 715-1.

Several problems have been discovered in the CVS server, which serves
the popular Concurrent Versions System.  The Common Vulnerability and
Exposures project identifies the following problems:

CVE-2004-1342

Maks Polunin and Alberto Garcia discovered independently that
using the pserver access method in connection with the repouid
patch that Debian uses it is possible to bypass the password and
gain access to the repository in question.

CVE-2004-1343

Alberto Garcia discovered that a remote user can cause the cvs
server to crash when the cvs-repouids file exists but does not
contain a mapping for the current repository, which can be used as
a denial of service attack.

For the stable distribution (woody) these problems have been fixed in
version 1.11.1p1debian-10.

For the unstable distribution (sid) these problems have been fixed in
version 1.12.9-11.

We recommend that you upgrade your cvs package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20715-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 715-1 (cvs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cvs", ver:"1.11.1p1debian-10", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
