# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 728-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53556);
 script_cve_id("CVE-2005-1151", "CVE-2005-1152");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 728-1 (qpopper)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to qpopper
announced via advisory DSA 728-1.

Two bugs have been discovered in qpopper, an enhanced Post Office
Protocol (POP3) server.  The Common Vulnerability and Exposures
project identifies the following problems:

CVE-2005-1151

Jens Steube discovered that while processing local files owned or
provided by a normal user privileges weren't dropped, which could
lead to the overwriting or creation of arbitrary files as root.

CVE-2005-1152

The upstream developers noticed that qpopper could be tricked to
creating group- or world-writable files.

For the stable distribution (woody) these problems have been fixed in
version 4.0.4-2.woody.5.

For the testing distribution (sarge) these problems have been fixed in
version 4.0.5-4sarge1.

For the unstable distribution (sid) these problems will be fixed in
version 4.0.5-4sarge1.

We recommend that you upgrade your qpopper package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20728-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 728-1 (qpopper)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"qpopper", ver:"4.0.4-2.woody.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qpopper-drac", ver:"4.0.4-2.woody.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qpopper", ver:"4.0.5-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qpopper-drac", ver:"4.0.5-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
