# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 801-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55233);
 script_bugtraq_id(14673);
 script_cve_id("CVE-2005-2496");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 801-1 (ntp)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ntp
announced via advisory DSA 801-1.

SuSE developers discovered that ntp confuses the given group id with
the group id of the given user when called with a group id on the
commandline that is specified as a string and not as a numeric gid,
which causes ntpd to run with different privileges than intended.

The old stable distribution (woody) is not affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 4.2.0a+stable-2sarge1.

The unstable distribution (sid) is not affected by this problem.

We recommend that you upgrade your ntp-server package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20801-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 801-1 (ntp)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.0a+stable-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.0a+stable-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-refclock", ver:"4.2.0a+stable-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-server", ver:"4.2.0a+stable-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-simple", ver:"4.2.0a+stable-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.0a+stable-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
