# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 845-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55540);
 script_bugtraq_id(15019);
 script_cve_id("CVE-2005-3118");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 845-1 (mason)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mason
announced via advisory DSA 845-1.

Christoph Martin noticed that upon configuration mason, which
interactively creates a Linux packet filtering firewall, does not
install the init script to actually load the firewall during system
boot.  This will leave the machine without a firewall after a reboot.

For the old stable distribution (woody) this problem has been fixed in
version 0.13.0.92-2woody1.

For the stable distribution (sarge) this problem has been fixed in
version 1.0.0-2.2.

For the unstable distribution (sid) this problem has been fixed in
version 1.0.0-3.

We recommend that you upgrade your mason package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20845-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 845-1 (mason)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mason", ver:"0.13.0.92-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mason", ver:"1.0.0-2.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
