# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 870-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55745);
 script_bugtraq_id(15191);
 script_cve_id("CVE-2005-2959");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 870-1 (sudo)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to sudo
announced via advisory DSA 870-1.

Tavis Ormandy noticed that sudo, a program that provides limited super
user privileges to specific users, does not clean the environment
sufficiently.  The SHELLOPTS and PS4 variables are dangerous and are
still passed through to the program running as privileged user.  This
can result in the execution of arbitrary commands as privileged user
when a bash script is executed.  These vulnerabilities can only be
exploited by users who have been granted limited super user
privileges.

For the old stable distribution (woody) this problem has been fixed in
version 1.6.6-1.4.

For the stable distribution (sarge) this problem has been fixed in
version 1.6.8p7-1.2.

For the unstable distribution (sid) this problem has been fixed in
version 1.6.8p9-3.

We recommend that you upgrade your sudo package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20870-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 870-1 (sudo)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sudo", ver:"1.6.6-1.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sudo", ver:"1.6.8p7-1.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
