# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 943-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56147);
 script_bugtraq_id(15629);
 script_cve_id("CVE-2005-3962");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 943-1 (perl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to perl
announced via advisory DSA 943-1.

Jack Louis discovered an integer overflow in Perl, Larry Wall's
Practical Extraction and Report Language, that allows attackers to
overwrite arbitrary memory and possibly execute arbitrary code via
specially crafted content that is passed to vulnerable format strings
of third party software.

The old stable distribution (woody) does not seem to be affected by
this problem.

For the stable distribution (sarge) this problem has been fixed in
version 5.8.4-8sarge3.

For the unstable distribution (sid) this problem has been fixed in
version 5.8.7-9.

We recommend that you upgrade your perl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20943-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 943-1 (perl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.8", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.8.4-8sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
