###############################################################################
# OpenVAS Vulnerability Test
# $Id: dokeos_34633.nasl 3194 2009-04-24 18:04:08Z mime $
#
# Dokeos 'whoisonline.php' Remote Code Execution Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100159);
 script_bugtraq_id(34633);
 script_version ("1.0");

 script_name(english:"Dokeos 'whoisonline.php' Remote Code Execution Vulnerability");
 desc["english"] = "

 Overview:
  Dokeos is prone to a remote code-execution vulnerability because the
  software fails to adequately sanitize user-supplied input.

  Exploiting this issue could allow an attacker to execute arbitrary
  code in the context of the vulnerable application.

  Dokeos prior to version 1.8.5 are vulnerable.

 See also:
  http://www.securityfocus.com/bid/34633

 Risk factor : High";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Dokeos is vulnerable to Remote Code Execution");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("dokeos_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/dokeos")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less_equal(version: vers, test_version: "1.8.5")) {
      security_hole(port:port);
      exit(0);
  }  

}   

exit(0);
