# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0550 (amarok)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63215);
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-0550 (amarok)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to amarok
announced via advisory FEDORA-2009-0550.

Update Information:

An update to the latest release, includes new features such
as queuing, playlist search and filtering as well as stop
after current track. And, long awaited and finally available:
sorting the collection by composer.

Also includes a security fix concerning the parsing of
malformed Audible digital audio files.  For further details,
see http://amarok.kde.org/en/releases/2.0.1.1

ChangeLog:

* Fri Jan  9 2009 Rex Dieter  - 2.0.1.1-1
- amarok-2.0.1.1
* Tue Jan  6 2009 Rex Dieter  - 2.0.1-1
- amarok-2.0.1
* Tue Dec  9 2008 Rex Dieter  - 2.0-2
- respin tarball

References:

[ 1 ] Bug #479560 - amarok: multiple buffer overflows when parsing Audible .aa files
https://bugzilla.redhat.com/show_bug.cgi?id=479560

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update amarok' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0550

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-0550 (amarok)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"amarok", rpm:"amarok~2.0.1.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-debuginfo", rpm:"amarok-debuginfo~2.0.1.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
