# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1295 (gnumeric)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63377);
 script_cve_id("CVE-2009-5983", "CVE-2009-0318");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-1295 (gnumeric)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gnumeric
announced via advisory FEDORA-2009-1295.

Gnumeric is a spreadsheet program for the GNOME GUI desktop
environment.

ChangeLog:

* Fri Jan 30 2009 Huzaifa Sidhpurwala  1:1.8.2-4
- Resolves CVE-2009-5983
- Version Bump

References:

[ 1 ] Bug #481572 - CVE-2009-0318 Gnumeric: untrusted python modules search path
https://bugzilla.redhat.com/show_bug.cgi?id=481572

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gnumeric' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1295

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-1295 (gnumeric)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gnumeric", rpm:"gnumeric~1.8.2~4.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnumeric-devel", rpm:"gnumeric-devel~1.8.2~4.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnumeric-plugins-extras", rpm:"gnumeric-plugins-extras~1.8.2~4.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnumeric-debuginfo", rpm:"gnumeric-debuginfo~1.8.2~4.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
