# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1914 (perl-Crypt-OpenSSL-DSA)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63427);
 script_cve_id("CVE-2009-0129");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-1914 (perl-Crypt-OpenSSL-DSA)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to perl-Crypt-OpenSSL-DSA
announced via advisory FEDORA-2009-1914.

Crypt::OpenSSL::DSA - Digital Signature Algorithm using OpenSSL

Update Information:

Fixes CVE-2009-0129: The Crypto::OpenSSL::DSA module now croaks upon error
rather than returning a -1 to ensure programmers are not caught by surprise
which only checking for non-zero results.

ChangeLog:

* Wed Feb 18 2009 Wes Hardaker  - 0.13-9
- Version bump to solve build issues
* Wed Feb 18 2009 Wes Hardaker  - 0.13-8
- Fix CVE-2009-0129 and have do_verify croak on fatal error

References:

[ 1 ] Bug #486012 - CVE-2009-0129 perl-Crypt-OpenSSL-DSA: do_verify() doesn't fail on errors in OpenSSL DSA_do_verify()
https://bugzilla.redhat.com/show_bug.cgi?id=486012

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update perl-Crypt-OpenSSL-DSA' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1914

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-1914 (perl-Crypt-OpenSSL-DSA)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-Crypt-OpenSSL", rpm:"perl-Crypt-OpenSSL~DSA~0.13", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Crypt-OpenSSL", rpm:"perl-Crypt-OpenSSL~DSA~debuginfo", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
