# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2045 (libpng10)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63530);
 script_cve_id("CVE-2009-0040", "CVE-2008-1382");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-2045 (libpng10)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libpng10
announced via advisory FEDORA-2009-2045.

Update Information:

This release fixes a vulnerability in which some arrays of pointers are not
initialized prior to using malloc to define the pointers. If the application
runs out of memory while executing the allocation loop (which can be forced by
malevolent input), libpng10 will jump to a cleanup process that attempts to free
all of the pointers, including the undefined ones.    This issue has been
assigned CVE-2009-0040

References:

[ 1 ] Bug #486355 - CVE-2009-0040 libpng arbitrary free() flaw
https://bugzilla.redhat.com/show_bug.cgi?id=486355

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libpng10' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2045

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-2045 (libpng10)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libpng10", rpm:"libpng10~1.0.43~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng10-devel", rpm:"libpng10-devel~1.0.43~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng10-debuginfo", rpm:"libpng10-debuginfo~1.0.43~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
