# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3101 (seamonkey)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63723);
 script_cve_id("CVE-2009-1044", "CVE-2009-1169", "CVE-2009-0776", "CVE-2009-0771", "CVE-2009-0772", "CVE-2009-0773", "CVE-2009-0774", "CVE-2009-0357", "CVE-2009-0352", "CVE-2009-0353");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-3101 (seamonkey)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to seamonkey
announced via advisory FEDORA-2009-3101.

SeaMonkey is an all-in-one Internet application suite. It includes
a browser, mail/news client, IRC client, JavaScript debugger, and
a tool to inspect the DOM for web pages. It is derived from the
application formerly known as Mozilla Application Suite.

Update Information:

http://www.mozilla.org/security/known-vulnerabilities/seamonkey11.html

ChangeLog:

* Fri Mar 27 2009 Christopher Aillon  - 1.15.1-3
- Add patches for MFSA-2009-12, MFSA-2009-13
* Wed Mar 25 2009 Christopher Aillon  - 1.15.1-2
- Update default homepage

References:

[ 1 ] Bug #492212 - CVE-2009-1044 Firefox XUL garbage collection issue (cansecwest pwn2own)
https://bugzilla.redhat.com/show_bug.cgi?id=492212
[ 2 ] Bug #492211 - CVE-2009-1169 Firefox XSLT memory corruption issue
https://bugzilla.redhat.com/show_bug.cgi?id=492211
[ 3 ] Bug #488290 - CVE-2009-0776 Firefox XML data theft via RDFXMLDataSource and cross-domain redirect
https://bugzilla.redhat.com/show_bug.cgi?id=488290
[ 4 ] Bug #488272 - CVE-2009-0771 Firefox 3 Layout Engine Crashes
https://bugzilla.redhat.com/show_bug.cgi?id=488272
[ 5 ] Bug #488273 - CVE-2009-0772 Firefox 2 and 3 - Layout engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=488273
[ 6 ] Bug #488276 - CVE-2009-0773 Firefox 3 crashes in the JavaScript engine
https://bugzilla.redhat.com/show_bug.cgi?id=488276
[ 7 ] Bug #488283 - CVE-2009-0774 Firefox 2 and 3 crashes in the JavaScript engine
https://bugzilla.redhat.com/show_bug.cgi?id=488283
[ 8 ] Bug #483145 - CVE-2009-0357 Firefox XMLHttpRequest allows reading HTTPOnly cookies
https://bugzilla.redhat.com/show_bug.cgi?id=483145
[ 9 ] Bug #483139 - CVE-2009-0352 Firefox layout crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=483139
[ 10 ] Bug #483141 - CVE-2009-0353 Firefox javascript crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=483141

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update seamonkey' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3101

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-3101 (seamonkey)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.1.15~3.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.1.15~3.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
