#
#VID 09d418db-70fd-11d8-873f-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52501);
 script_cve_id("CVE-2003-0993");
 script_bugtraq_id(9829);
 script_version ("$");
 name["english"] = "FreeBSD Ports: apache";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   apache
   apache+mod_ssl
   apache+ssl
   ru-apache
   ru-apache+mod_ssl

CVE-2003-0993
mod_access in Apache 1.3 before 1.3.30, when running big-endian 64-bit
platforms, does not properly parse Allow/Deny rules using IP addresses
without a netmask, which could allow remote attackers to bypass
intended access restrictions.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://cvs.apache.org/viewcvs.cgi/apache-1.3/src/modules/standard/mod_access.c?r1=1.46&r2=1.47
http://www.apacheweek.com/features/security-13
http://nagoya.apache.org/bugzilla/show_bug.cgi?id=23850
http://marc.theaimsgroup.com/?l=apache-cvs&m=107869603013722
http://www.vuxml.org/freebsd/09d418db-70fd-11d8-873f-0020ed76ef5a.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: apache";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"apache");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.29_2")<0) {
    security_note(0, data:"Package apache version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"apache+mod_ssl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.29+2.8.16_1")<0) {
    security_note(0, data:"Package apache+mod_ssl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"apache+ssl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.29.1.53_1")<0) {
    security_note(0, data:"Package apache+ssl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ru-apache");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.29+30.19_1")<0) {
    security_note(0, data:"Package ru-apache version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ru-apache+mod_ssl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.29+30.19+2.8.16_1")<0) {
    security_note(0, data:"Package ru-apache+mod_ssl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
