#
#VID 45298931-b3bf-11dd-80f8-001cc0377035
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 45298931-b3bf-11dd-80f8-001cc0377035
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61872);
 script_cve_id("CVE-2008-4989");
 script_bugtraq_id(32232);
 script_version ("$");
 name["english"] = "FreeBSD Ports: gnutls";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gnutls

CVE-2008-4989
The _gnutls_x509_verify_certificate function in lib/x509/verify.c in
libgnutls in GnuTLS before 2.6.1 trusts certificate chains in which
the last certificate is an arbitrary trusted, self-signed certificate,
which allows man-in-the-middle attackers to insert a spoofed
certificate for any Distinguished Name (DN).

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.gnu.org/software/gnutls/security.html
http://lists.gnu.org/archive/html/gnutls-devel/2008-11/msg00017.html
http://www.vuxml.org/freebsd/45298931-b3bf-11dd-80f8-001cc0377035.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: gnutls";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gnutls");
if(!isnull(bver) && revcomp(a:bver, b:"2.4.2")<0) {
    security_note(0, data:"Package gnutls version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
