#
#VID daf045d7-b211-11dd-a987-000c29ca8953
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID daf045d7-b211-11dd-a987-000c29ca8953
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61873);
 script_cve_id("CVE-2008-4309");
 script_version ("$");
 name["english"] = "FreeBSD Ports: net-snmp";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   net-snmp
   net-snmp53

CVE-2008-4309
Integer overflow in the netsnmp_create_subtree_cache function in
agent/snmp_agent.c in net-snmp 5.4 before 5.4.2.1, 5.3 before 5.3.2.3,
and 5.2 before 5.2.5.1 allows remote attackers to cause a denial of
service (crash) via a crafted SNMP GETBULK request, which triggers a
heap-based buffer overflow,  related to the number of responses or
repeats.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://sourceforge.net/forum/forum.php?forum_id=882903
http://www.openwall.com/lists/oss-security/2008/10/31/1
http://net-snmp.svn.sourceforge.net/viewvc/net-snmp/tags/Ext-5-2-5-1/net-snmp/agent/snmp_agent.c?r1=17271&r2=17272&pathrev=17272
http://www.vuxml.org/freebsd/daf045d7-b211-11dd-a987-000c29ca8953.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: net-snmp";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"net-snmp");
if(!isnull(bver) && revcomp(a:bver, b:"5.4.2.1")<0) {
    security_note(0, data:"Package net-snmp version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"net-snmp53");
if(!isnull(bver) && revcomp(a:bver, b:"5.3.2.3")<0) {
    security_note(0, data:"Package net-snmp53 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
