#
#VID 13b0c8c8-bee0-11dd-a708-001fc66e7203
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 13b0c8c8-bee0-11dd-a708-001fc66e7203
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63107);
 script_cve_id("CVE-2005-0448");
 script_version ("$");
 name["english"] = "FreeBSD Ports: p5-File-Path";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: p5-File-Path

CVE-2005-0448
Race condition in the rmtree function in File::Path.pm in Perl before
5.8.4 allows local users to create arbitrary setuid binaries in the
tree being deleted, a different vulnerability than CVE-2004-0452.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=286905
http://www.openwall.com/lists/oss-security/2008/11/28/1
http://www.gossamer-threads.com/lists/perl/porters/233699#233699
http://www.vuxml.org/freebsd/13b0c8c8-bee0-11dd-a708-001fc66e7203.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: p5-File-Path";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"p5-File-Path");
if(!isnull(bver) && revcomp(a:bver, b:"2.07_1")<0) {
    security_note(0, data:"Package p5-File-Path version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
